<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Lib\Util;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Models\Baratazos;
use Illuminate\Support\Facades\Log;

class BaratazosController extends Controller
{
    public function getAll(Request $request)
    {
        try {
            Log::info('Inicio del proceso de sincronización Baratazo');
            DB::beginTransaction();

            $resultados = DB::connection('sqlsrv')->select('SET NOCOUNT ON; EXEC dbo.WebListaBaratazos');
            $idsEncontrados = [];

            foreach ($resultados as $resultado) {
                $registro = Baratazos::find($resultado->idPromocion);

                if ($registro) {
                    $registro->update((array) $resultado);
                    $idsEncontrados[] = $registro->idPromocion;
                } else {
                    Baratazos::create((array) $resultado);
                    $idsEncontrados[] = $resultado->idPromocion;
                }
            }

            Baratazos::whereNotIn('idPromocion', $idsEncontrados)->delete();
            DB::commit();

            Log::info('Proceso de sincronización completado Baratazo');
            return response()->json('Proceso terminado correctamente Baratazo');
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error: ' . $e->getMessage()], 500);
        }
    }
}

