<?php

namespace App\Http\Controllers;
use App\Models\Bodega;
use Illuminate\Support\Facades\DB;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Lib\Util;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Models\Producto;
use Illuminate\Support\Facades\Log;
class BodegaController extends Controller
{
    public function getAll(Request $request)
    {
        try{
        Log::info('inicio Bodega');
        $resultados = DB::connection('sqlsrv')->select('SET NOCOUNT ON ; EXEC dbo.BuzonBodegaExp');
        $idsEncontrados = [];

        foreach ($resultados as $resultado) {
            $registro = Bodega::where('IdBodega', $resultado->IdBodega)->first();

            if ($registro) {
                $registro->IdBodega = $resultado->IdBodega;
                $registro->Nombre = $resultado->Nombre;
                $registro->Bodega = $resultado->Bodega;
                $registro->Codigo = $resultado->Codigo;
                $registro->idCiudad = $resultado->idCiudad;
                $registro->Region = $resultado->Region;
                $registro->idProvincia = $resultado->idProvincia;
                $registro->save();
            
            } else {
                $nuevoRegistro = new Bodega((array)$resultado);
                $nuevoRegistro->save();         
            }
        }
        Log::info('termina Bodega');
        return response()->json('proceso terminado Bodega');
        }catch (\Exception $e) {
            Log::error('Error Bodega Detalles: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error a Detalles: ' . $e->getMessage()], 500);
        }
    }

    public function getBodegaList($idCiudad)
    {
        $Bodega = Bodega::where('idCiudad', $idCiudad)->get();
        return response()->json($Bodega);
    }
}

