<?php

namespace App\Http\Controllers;
use App\Mail\MiCorreo;
use App\Models\BuzonCliente;
use App\Models\BuzonGestionCobranza;
use App\Models\BuzonGestionCredito;
use App\Models\BuzonQuejasSF;
use App\Models\BuzonServicioClienteVenta;
use App\Models\BuzonServicioTecnico;
use Carbon\Traits\ToStringFormat;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Lib\Util;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Models\BuzonCab;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use Dompdf\Dompdf;

class BuzonCabController extends Controller
{
    public function BuzonCabCre(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();

        try{
        Log::info('inicio BuzonCabAqui vamos');
        Log::info($request);
        //Creación del cliente
        $BuzonCliente = $request->input('BuzonCliente');
        Log::info($BuzonCliente);
        // Crea una instancia de Request
        $requestBuzonCliente = new Request($BuzonCliente);
        // Enviar el request al metodo BuzonGestionCredito
        $response = $this -> BuzonCliente($requestBuzonCliente);
        $content = $response->getContent();
        $data = json_decode($content, true);
        if($data !== null && json_last_error() == JSON_ERROR_NONE)
        {
            $value = $data['message'];
            Log::info($value);
        }
        else
        {
            echo "Error al decodificar el JSON: ", json_last_error_msg();
        }
        $request['idCliente'] = strval($value);
        $data = $request->validate([
            'Ciudad' => 'required|integer',
            'Almacen' => 'required|integer',
            'ProporcionarDatosCliente' => 'required|boolean',
            'idCliente' => 'required|integer',
        ]);

        $nuevoRegistro = BuzonCab::create($data);
        //Obtengo la id de la cabecera
        $idBuzonCab = $nuevoRegistro->idBuzonCab;  

        //Guardar Servicio Cliente Ventas
        $BuzonServicioClienteVenta = $request->input('BuzonServicioClienteVenta');
        $BuzonServicioClienteVenta['idBuzonCab'] = strval($idBuzonCab);
        Log::info($BuzonServicioClienteVenta);
        // Crea una instancia de Request
        $requestBuzonGestionCredito = new Request($BuzonServicioClienteVenta);
        // Enviar el request al metodo BuzonGestionCredito
        $response = $this -> BuzonServicioClienteVenta($requestBuzonGestionCredito);

        //Guardar gestión de crédito
        $BuzonGestionCredito = $request->input('BuzonGestionCredito');
        $BuzonGestionCredito['idBuzonCab'] = strval($idBuzonCab);
        Log::info($BuzonGestionCredito);
        // Crea una instancia de Request
        $requestBuzonGestionCredito = new Request($BuzonGestionCredito);
        // Enviar el request al metodo BuzonGestionCredito
        $response = $this -> BuzonGestionCredito($requestBuzonGestionCredito);

        //Guardar gestión Cobranzas
        $BuzonGestionCobranza = $request->input('BuzonGestionCobranza');
        $BuzonGestionCobranza['idBuzonCab'] = strval($idBuzonCab);
        Log::info($BuzonGestionCobranza);
        // Crea una instancia de Request
        $requestBuzonGestionCobranza = new Request($BuzonGestionCobranza);
        // Enviar el request al metodo BuzonGestionCredito
        $response = $this -> BuzonGestionCobranza($requestBuzonGestionCobranza);

        //Guardar Buzón Servicio Técnico
        $BuzonServicioTecnico = $request->input('BuzonServicioTecnico');
        $BuzonServicioTecnico['idBuzonCab'] = strval($idBuzonCab);
        Log::info($BuzonServicioTecnico);
        // Crea una instancia de Request
        $requestBuzonServicioTecnico = new Request($BuzonServicioTecnico);
        // Enviar el request al metodo BuzonGestionCredito
        $response = $this -> BuzonServicioTecnico($requestBuzonServicioTecnico);

        //Guardar BuzonQuejasSF
        $BuzonQuejasSF = $request->input('BuzonQuejasSF');
        $BuzonQuejasSF['idBuzonCab'] = strval($idBuzonCab);
        Log::info($BuzonQuejasSF);
        // Crea una instancia de Request
        $requestBuzonQuejasSF = new Request($BuzonQuejasSF);
        // Enviar el request al metodo BuzonGestionCredito
        $response = $this -> BuzonQuejasSF($requestBuzonQuejasSF);

        Log::info('Buzón de quejas, sugerencias, y felicitaciones registrado exitosamente.');
        DB::commit();
        return response()->json(['message' => 'Buzón de quejas, sugerencias, y felicitaciones registrado exitosamente.',
        'idBuzonCab' => strval($idBuzonCab)]);


        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonCabCre: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonCabCre: ' . $e->getMessage()], 500);
        }
    }

    static function BuzonGestionCredito(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();
        try{
        Log::info('inicio BuzonGestionCredito vamos');
        //Guardar gestión de crédito
        $data = $request->validate([
                'GCRPregunta1' => 'required|string',
                'GCRPregunta2' => 'required|boolean',
                'GCRPregunta3' => 'required|boolean',
                'GCRPregunta4' => 'required|boolean',
                'GCRPregunta5' => 'required|boolean',
                'GCRPregunta6' => 'required|integer',
                'GCRPregunta7' => 'required|string',
                'idBuzonCab' => 'required|integer',
        ]);
        //Guardar BuzonGestionCredito
        BuzonGestionCredito::create($data);
        Log::info('Formulario registrado exitosamente');

        DB::commit();
        return response()->json(['message' => 'Gestión de crédito registrada exitosamente.']);

        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonGestionCredito: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonGestionCredito: ' . $e->getMessage()], 500);
        }
    }

    static function BuzonServicioClienteVenta(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();
        try{
        Log::info('inicio BuzonServicioClienteVenta vamos');
        //Guardar gestión de crédito
        //region Validaciones
            // Verificar si el checkbox está marcado
            $SCVPregunta8 = $request->input('SCVPregunta8');
            Log::info('SCVPregunta8: '. strval($SCVPregunta8));

            // Definir reglas de validación básicas
            $rules = [
                'SCVPregunta1' => 'required|date',
                'SCVPregunta2' => 'required|string',
                'SCVPregunta3' => 'required|boolean',
                'SCVPregunta4' => 'required|boolean',
                'SCVPregunta5' => 'required|boolean',
                'SCVPregunta6' => 'required|boolean',
                'SCVPregunta7' => 'required|string',
                'SCVPregunta8' => 'required|boolean',
                'SCVPregunta10' => 'required|integer',
                'SCVPregunta11' => 'required|string',
                'SCVPregunta12' => 'required|string',
                'idBuzonCab' => 'required|integer'
            ];
            // Procesar los datos según el valor del checkbox
            if ($SCVPregunta8) {
            }else{
                // Lógica cuando el checkbox está marcado
                $rules['SCVPregunta9'] = 'required|string|max:500';
            }
            // Validar los datos
            $data = $request->validate($rules);
        //endregion
        //Guardar BuzonServicioClienteVenta
        BuzonServicioClienteVenta::create($data);
        Log::info('Formulario registrado exitosamente');

        DB::commit();
        return response()->json(['message' => 'Servicio al cliente registrado exitosamente.']);

        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonServicioClienteVenta: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonServicioClienteVenta: ' . $e->getMessage()], 500);
        }
    }

    static function BuzonGestionCobranza(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();
        try{
        Log::info('inicio BuzonGestionCobranza vamos');
        //Guardar gestión de crédito
        $data = $request->validate([
                'GCOPregunta1' => 'required|boolean',
                'GCOPregunta2' => 'required|boolean',
                'GCOPregunta3' => 'required|string',
                'GCOPregunta4' => 'required|string',
                'GCOPregunta5' => 'required|string',
                'idBuzonCab' => 'required|integer'
        ]);
        //Guardar BuzonGestionCobranza
        BuzonGestionCobranza::create($data);
        Log::info('Formulario registrado exitosamente');

        DB::commit();
        return response()->json(['message' => 'Gestión cobranzas registrada exitosamente.']);

        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonGestionCobranza: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonServicioClienteVenta: ' . $e->getMessage()], 500);
        }
    }

    static function BuzonServicioTecnico(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();
        try{
        Log::info('inicio BuzonServicioTecnico vamos');
        //Guardar gestión de crédito
        $data = $request->validate([
                'STCPregunta1' => 'required|string',
                'STCPregunta2' => 'required|boolean',
                'STCPregunta3' => 'required|string',
                'STCPregunta4' => 'required|integer',
                'STCPregunta5' => 'required|string',
                'STCPregunta6' => 'required|boolean',
                'STCPregunta7' => 'required|string',
                'STCPregunta8' => 'required|integer',
                'STCPregunta9' => 'required|string',
                'idBuzonCab' => 'required|integer'
        ]);
        //Guardar BuzonServicioTecnico
        BuzonServicioTecnico::create($data);
        Log::info('Formulario registrado exitosamente');

        DB::commit();
        return response()->json(['message' => 'Servicio técnico registrado exitosamente.']);

        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonServicioTecnico: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonServicioTecnico: ' . $e->getMessage()], 500);
        }
    }

    static function BuzonQuejasSF(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();
        try{
        Log::info('inicio BuzonQuejasSF vamos');
        //Guardar gestión de crédito
        $data = $request->validate([
                'QSFPregunta1' => 'required|date',
                'QSFPregunta2' => 'required|string',
                'idBuzonCab' => 'required|integer'
        ]);
        //Guardar BuzonQuejasSF
        BuzonQuejasSF::create($data);
        Log::info('Formulario registrado exitosamente');

        DB::commit();
        return response()->json(['message' => 'Quejas, sugerencias y felicitaciones registrada exitosamente.']);

        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonQuejasSF: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonQuejasSF: ' . $e->getMessage()], 500);
        }
    }

    static function BuzonCliente(Request $request)
    {
        //Este proceso se realiza completamente, por lo que se realiza una transacción general.
        DB::beginTransaction();
        try{
        Log::info('inicio BuzonCliente vamos');
        
        //region Validaciones
        // Verificar si el checkbox está marcado
        $proporcionarDatos = $request->has('ProporcionarDatosCliente');
        Log::info('proporcionarDatos: '. strval($proporcionarDatos));

         // Definir reglas de validación básicas
         $rules = [
           'AutorizacionTratamientoDatos'  => 'required|boolean',
            'ProporcionarDatosCliente' => 'nullable|boolean',
         ];
        // Procesar los datos según el valor del checkbox
        if ($proporcionarDatos) {
            // Lógica cuando el checkbox está marcado
            // Por ejemplo, guardar los datos en la base de datos
            $rules['NombreCompleto'] = 'required|string|max:255';
            $rules['Cedula'] = 'required|string|max:255';
            $rules['Email'] = 'required|string|max:255';
            $rules['Celular'] = 'required|string|max:255';
        }
        // Validar los datos
         $data = $request->validate($rules);
         //endregion

        //Guardar BuzonCliente
        $nuevoRegistro = BuzonCliente::create($data);
         //Obtengo la id de la cabecera
        $idBuzonCliente = $nuevoRegistro->idBuzonCliente;  
        
        Log::info('Cliente registrado exitosamente.');
        DB::commit();
        return response()->json(['message' => strval($idBuzonCliente)]);

        }catch (\Exception $e) {
            DB::rollBack();
            Log::error('Error BuzonCliente: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error en BuzonCliente: ' . $e->getMessage()], 500);
        }
    }

    public function enviarCorreo(Request $request)
    {
        Log::info('Ingresa a enviarCorreo.');
        $detalle = [
            'nombre' => 'Juan',
            'mensaje' => 'Este es un mensaje de prueba.'
        ];

        Mail::to('angelomar1996@gmail.com')->send(new MiCorreo($detalle));

        return response()->json(['message' => 'Correo buzón de quejas, sugerencias, y felicitaciones enviado exitosamente.']);
    }

    
}

