<?php

namespace App\Http\Controllers;
use App\Models\ClienteCiudad;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
class ClienteCiudadController extends Controller
{
    public function getAll(Request $request)
    {
        try{
        Log::info('inicio ClienteCiudad');
        $resultados = DB::connection('sqlsrv')->select('SET NOCOUNT ON ; EXEC dbo.BuzonClienteCiudadExp');
        $idsEncontrados = [];

        foreach ($resultados as $resultado) {
            $registro = ClienteCiudad::where('idCiudad', $resultado->idCiudad)->first();

            if ($registro) {
                $registro->idCiudad = $resultado->idCiudad;
                $registro->Ciudad = $resultado->Ciudad;
                $registro->Codigo = $resultado->Codigo;
                $registro->save();
            
            } else {
                $nuevoRegistro = new ClienteCiudad((array)$resultado);
                $nuevoRegistro->save();         
            }
        }
        Log::info('termina ClienteCiudad');
        return response()->json('proceso terminado ClienteCiudad');
        }catch (\Exception $e) {
            Log::error('Error ClienteCiudad Detalles: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error a Detalles: ' . $e->getMessage()], 500);
        }
    }

    public function getClienteCiudadList(Request $request)
    {
        $ClienteCiudad = ClienteCiudad::all();
        return response()->json($ClienteCiudad);
    }
}

