<?php

namespace App\Http\Controllers;

use App\Models\Avenderores;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
class Com_AsignacionDeVendedores extends Controller
{
    
    public function getAll(Request $request)
    {
        try{

            Log::info('Iniciando asignacion vendedores: getAll');

            $resultados = DB::connection('sqlsrv')->select('SET NOCOUNT ON; EXEC dbo.Com_ConsultaAsginacionVendedoresPW');
        
            // $resultados contendrá el resultado de la consulta al procedimiento almacenado
            $idsEncontrados = [];
  
        foreach ($resultados as $resultado) {
             // Busca un registro existente por idarticulo
             $registro =Avenderores::where('idpersonal', $resultado->idpersonal)->first();
             
             if ($registro) {
                 //  todos los campos según el array $fillable
                 $registro->fill((array)$resultado);
                 $registro->estado = 1; // Establece el estado en 1
                 $registro->save();
                 $idsEncontrados[] =$registro->idpersonal;
             } else {
                 // Crea un nuevo registro si no se encuentra
                 $nuevoRegistro = new Avenderores((array)$resultado);
                 $nuevoRegistro->estado = 1; // Establece el estado en 1
                 $nuevoRegistro->save();
                 $idsEncontrados[] =  $nuevoRegistro->idpersonal;
             }
    
        }
      
        Avenderores::whereNotIn('idpersonal', $idsEncontrados)->update(['estado' => 0]);
        Log::info('Tarea programada completada con éxito: getAll');
        // Devuelve los resultados en formato JSON
        return response()->json('dbo.Com_ConsultaAsginacionVendedoresPW ejecutado correctamente!!');
        }catch (\Exception $e) {
            // Captura cualquier excepción y muestra un mensaje de error
            Log::error('Error en la tarea programada: getAll - Detalles: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error al procesar los datos. Detalles: ' . $e->getMessage()], 500);
        }
    }

}
