<?php

namespace App\Http\Controllers;
use App\Models\Bodega;
use App\Models\BuzonCab;
use App\Models\BuzonCliente;
use App\Models\BuzonGestionCobranza;
use App\Models\BuzonGestionCredito;
use App\Models\BuzonQuejasSF;
use App\Models\BuzonServicioClienteVenta;
use App\Models\BuzonServicioTecnico;
use App\Models\ClienteCiudad;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;

class PdfController extends Controller
{
    /**
     * Genera y descarga un PDF.
     *
     * @return \Illuminate\Http\Response
     */
 

    public function generatePdfAsBase64($idBuzonCab)
    {
        // Datos a pasar a la vista
        //$data = ['title' => 'Welcome to PDF generation in Laravel'];
        //Datos BuzonCab
        $objeto = BuzonCab::find($idBuzonCab); // Suponiendo que estás recuperando el objeto por su ID
        // Cargar la vista y convertirla a PDF
        $objeto->Ciudad = ClienteCiudad::where('idCiudad', $objeto['Ciudad'])->pluck('Ciudad')->first();
        $objeto->Almacen = Bodega::where('Bodega', $objeto['Almacen'])->pluck('Nombre')->first();
        //Proporcionar los datos
        $objeto->ProporcionarDatosCliente = $objeto->ProporcionarDatosCliente ? "SI" : "NO";
        $objeto['BuzonCliente'] = BuzonCliente::find($objeto['idCliente']);
        $objeto->BuzonCliente->AutorizacionTratamientoDatos = $objeto->BuzonCliente->AutorizacionTratamientoDatos ? "SI" : "NO";
        Log::info($objeto['idBuzonCab']);
        $idBuzonCab = strval($objeto['idBuzonCab']);
        $objeto['BuzonServicioClienteVenta'] = BuzonServicioClienteVenta::where('idBuzonCab',$idBuzonCab)->first();
        $fecha = new \DateTime($objeto->BuzonServicioClienteVenta->SCVPregunta1);
        $objeto->BuzonServicioClienteVenta->SCVPregunta1 = $fecha->format('d/m/Y');
        $objeto->BuzonServicioClienteVenta->SCVPregunta3 = $objeto->BuzonServicioClienteVenta->SCVPregunta3 ? "SI" : "NO";
        $objeto->BuzonServicioClienteVenta->SCVPregunta4 = $objeto->BuzonServicioClienteVenta->SCVPregunta4 ? "SI" : "NO";
        $objeto->BuzonServicioClienteVenta->SCVPregunta5 = $objeto->BuzonServicioClienteVenta->SCVPregunta5 ? "SI" : "NO";
        $objeto->BuzonServicioClienteVenta->SCVPregunta6 = $objeto->BuzonServicioClienteVenta->SCVPregunta6 ? "SI" : "NO";
        $objeto->BuzonServicioClienteVenta->SCVPregunta8 = $objeto->BuzonServicioClienteVenta->SCVPregunta8 ? "SI" : "NO";

        $objeto['BuzonGestionCredito'] = BuzonGestionCredito::where('idBuzonCab',$idBuzonCab)->first();
        $objeto['BuzonGestionCobranza'] = BuzonGestionCobranza::where('idBuzonCab',$idBuzonCab)->first();
        $objeto['BuzonServicioTecnico'] = BuzonServicioTecnico::where('idBuzonCab',$idBuzonCab)->first();
        $objeto['BuzonQuejasSF'] = BuzonQuejasSF::where('idBuzonCab',$idBuzonCab)->first();

        Log::info($objeto);

        $pdf = PDF::loadView('pdf_view', compact('objeto'));

        // Obtener el contenido del PDF como una cadena
        $pdfContent = $pdf->output();

        // Codificar el contenido del PDF como una cadena Base64
        $base64Pdf = base64_encode($pdfContent);

        // Retornar el PDF codificado como Base64 en formato JSON
        return response()->json(['pdf' => $base64Pdf]);
    }

    public function sendPdfByEmail(Request $request)
    {
        // Obtener la cadena Base64 del cuerpo de la solicitud
        $base64Pdf = $request->input('pdf');

        // Decodificar la cadena Base64 a contenido binario
        $pdfContent = base64_decode($base64Pdf);

        // Generar un nombre de archivo aleatorio para el PDF
        $pdfFileName = 'pdf_' . Str::random(10) . '.pdf';

        // Guardar el contenido binario como un archivo PDF
        file_put_contents($pdfFileName, $pdfContent);

        // Enviar el PDF por correo electrónico
        Mail::raw('Adjunto encontrarás el PDF.', function ($message) use ($pdfFileName) {
            $message->to('aopilatuna@point.com.ec')
                    ->subject('PDF Adjunto')
                    ->attach($pdfFileName);
        });

        // Eliminar el archivo PDF temporal
        unlink($pdfFileName);

        // Retornar una respuesta
        return response()->json(['message' => 'El PDF ha sido enviado por correo electrónico.']);
    }

    public function BuzonEnvioCorreo($idBuzonCab)
    {
        $baseUrl = env('SERVICE_BASE_URL');
        $Url = $baseUrl . 'generate-pdf-as-base64/'. strval($idBuzonCab);
        Log::info('Url servicio: '. $Url);
        //Generar PDF
        $response = Http::get($Url);
        // Verificar que la solicitud fue exitosa
        if ($response->successful()) 
        {
            $pdf = $response->json();
            Log::info($pdf);
            //Enviar correo
            $baseUrl = env('SERVICE_BASE_URL');
            $Url = $baseUrl . 'send-pdf-by-email/';
            Log::info('Url servicio: '. $Url);
            $response = Http::get($Url, $pdf);
            Log::info($response);
            if ($response->successful()) 
            {
                return response()->json(['message' => 'El PDF ha sido enviado por correo electrónico.']);
            }
        }
        else
        {
            return response()->json(['error' => 'El PDF no se envío por correo electrónico.']);
        }



    }
}