<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Lib\Util;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Models\Producto;
use Illuminate\Support\Facades\Log;
class ProductosController extends Controller
{
    public function getAll(Request $request)
    {
        try{
        Log::info('inicio Productos');
        $resultados = DB::connection('sqlsrv')->select('SET NOCOUNT ON ; EXEC dbo.Web_Productos_Base');
        $idsEncontrados = [];

        foreach ($resultados as $resultado) {
            $registro = Producto::where('idarticulo', $resultado->idarticulo)->first();

            if ($registro) {
                $registro->Existencia = $resultado->Existencia;
                $registro->imagen_url = $resultado->imagen_url;
                $registro->Tarjeta = $resultado->Tarjeta;
                $registro->Credito = $resultado->Credito;
                $registro->estado = 0;
                $registro->save();
                $idsEncontrados[] = $registro->idarticulo;
            
            } else {
                $nuevoRegistro = new Producto((array)$resultado);
                $nuevoRegistro->estado = 1; 
                $nuevoRegistro->save();
                $idsEncontrados[] = $nuevoRegistro->idarticulo;             
            }
        }
     
        Producto::whereNotIn('idarticulo', $idsEncontrados)->update(['estado' => 2, 'Existencia' => 0]);
        Log::info('termina Productos');
        return response()->json('proceso terminado Productos');
        }catch (\Exception $e) {
            Log::error('Error Productos Detalles: ' . $e->getMessage());
            return response()->json(['error' => 'Ocurrió un error a Detalles: ' . $e->getMessage()], 500);
        }
    }
}

