<?php
namespace App\Http\Controllers;

use App\Models\Bodega;
use App\Models\BuzonCab;
use App\Models\BuzonCliente;
use App\Models\ClienteCiudad;
use Illuminate\Http\Request;
use App\Models\User;
use App\Http\Controllers\BuzonCabController;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;

class UserController extends Controller
{
    public function create()
    {
        $baseUrl = env('SERVICE_BASE_URL');
        $Url = $baseUrl . 'ClienteCiudad/getClienteCiudadList';
        Log::info('Url servicio: '. $Url);
        $response = Http::get($Url);

        // Verificar que la solicitud fue exitosa
        if ($response->successful()) 
        {
            $ClienteCiudad = $response->json();
            // Pasar los datos a la vista
        } else {
            // Manejo de errores
            return view('user.create')->withErrors(['message' => 'Error al obtener las ciudades.']);
        }

        // Obtener todos los almacenes
        $Bodega = Bodega::all();

        return view('user.create', compact('ClienteCiudad', 'Bodega'));
    }

    public function store(Request $request)
    {
        $baseUrl = env('SERVICE_BASE_URL');
        $Url = $baseUrl . 'buzon/BuzonCabCre';
        Log::info('Url servicio: '. $Url);

        //Validaciones BuzonCab
        $responseBuzonCab = $this ->BuzonCab($request);
        $dataBuzonCab = $request->validate($responseBuzonCab);
        $BuzonCabCre = $dataBuzonCab;

        //Validaciones Cliente
        $responseBuzonCliente = $this ->BuzonCliente($request);
        $dataBuzonCliente = $request->validate($responseBuzonCliente);
        $BuzonCabCre['BuzonCliente'] = $dataBuzonCliente;

        //Validación BuzonServicioClienteVenta
        $responseBuzonServicioClienteVenta = $this ->BuzonServicioClienteVenta($request);
        $dataBuzonServicioClienteVenta = $request->validate($responseBuzonServicioClienteVenta);
        $BuzonCabCre['BuzonServicioClienteVenta'] = $dataBuzonServicioClienteVenta;

        //Envío al servicio
        $response = Http::get($Url, $BuzonCabCre);
        //Respuesta del servicio
        Log::info($response);
        Log::info(strval($response['idBuzonCab']));

        //$response = $this ->BuzonServicioClienteVenta($request);

        //Enviar el formulario por correo
        $baseUrl = env('SERVICE_BASE_URL');
        $Url = $baseUrl . 'buzon/BuzonEnvioCorreo/'. strval($response['idBuzonCab']);
        Log::info('Url servicio: '. $Url);
        //Generar PDF
        $response = Http::get($Url);
        Log::info($response);

        return redirect()->route('user.create')->with('success', 'Formulario registrado correctamente.');

    }

    public function BuzonCab(Request $request)
    {
        Log::info('inicio BuzonCliente vamos');

        //region Validaciones
            // Definir reglas de validación básicas
            $rules = [
                'Ciudad' => 'required|integer',
                'Almacen' => 'required|integer',
                'ProporcionarDatosCliente' => 'nullable|boolean'
            ];
        //endregion

        //Retorno
        return $rules;
    }

    public function BuzonCliente(Request $request)
    {
        Log::info('inicio BuzonCliente vamos');
        //region Validaciones
            // Verificar si el checkbox está marcado
            $proporcionarDatos = $request->has('ProporcionarDatosCliente');
            //Log::info('proporcionarDatos: '. strval($proporcionarDatos));

            // Definir reglas de validación básicas
            $rules = [
            'AutorizacionTratamientoDatos'  => 'required|boolean',
                'ProporcionarDatosCliente' => 'nullable|boolean',
            ];
            // Procesar los datos según el valor del checkbox
            if ($proporcionarDatos) {
                // Lógica cuando el checkbox está marcado
                // Por ejemplo, guardar los datos en la base de datos
                $rules['NombreCompleto'] = 'required|string|max:255';
                $rules['Cedula'] = 'required|string|max:255';
                $rules['Email'] = 'required|string|max:255';
                $rules['Celular'] = 'required|string|max:255';
            }
        //endregion

        //Retorno
        return $rules;
    }

    static function BuzonServicioClienteVenta(Request $request)
    {
        Log::info('inicio BuzonServicioClienteVenta vamos');
        //Guardar gestión de crédito
        $request['idBuzonCab'] = "0";
        //region Validaciones
            // Verificar si el checkbox está marcado
            $SCVPregunta8 = $request->input('SCVPregunta8');
            Log::info('SCVPregunta8: '. strval($SCVPregunta8));

            // Definir reglas de validación básicas
            $rules = [
                'SCVPregunta1' => 'required|date',
                'SCVPregunta2' => 'required|string',
                'SCVPregunta3' => 'required|boolean',
                'SCVPregunta4' => 'required|boolean',
                'SCVPregunta5' => 'required|boolean',
                'SCVPregunta6' => 'required|boolean',
                'SCVPregunta7' => 'required|string',
                'SCVPregunta8' => 'required|boolean',
                'SCVPregunta10' => 'required|integer',
                'SCVPregunta11' => 'required|string',
                'SCVPregunta12' => 'required|string',
                'idBuzonCab' => 'required|integer'
            ];
            // Procesar los datos según el valor del checkbox
            if ($SCVPregunta8) {
            }else{
                // Lógica cuando el checkbox está marcado
                $rules['SCVPregunta9'] = 'required|string|max:500';
            }
        //endregion

        //Retorno
        return $rules;
    }
}