<!DOCTYPE html>
<html>
<head>
    <title>Buzón</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .horizontal-radio-buttons {
            display: flex;
            justify-content: left;
            gap: 10px;
        }
        .horizontal-radio-buttons .form-check {
            display: flex;
            align-items: left;
        }
        .horizontal-radio-buttons .form-check-input {
            margin-right: 5px;
        }
        /*Ocultar Div Datos Cliente*/
        #datos_cliente {
            display: none; /* Inicialmente ocultar los campos del cliente */
        }
        /*Ocultar Div Datos Cliente*/
        #MostrarSCVPregunta9 {
            display: none; /* Inicialmente ocultar los campos del MostrarSCVPregunta9 */
        }
    .logo {
        width: 250px;
        height: auto;
        margin-top: 20px;
    }
    </style>
</head>
<body>
    <div class="container mt-5">

        <!-- Aquí es donde quieres ubicar la imagen -->
        <div class="row">
            <div class="col text-center">
                <img src="{{ asset('images/IMG_POINT_001.png') }}" alt="Logo de Point" class="img-fluid my-4 logo">
            </div>
        </div>
    
        <h5 class="mb-2 text-center">Estimado cliente, este formulario está dedicado única y exclusivamente para sugerencias, quejas y felicitaciones.</h5>
        <br/>
        <h5 class="mb-2 text-center">Para que su sugerencia o queja sea atendida, es necesario que indique claramente el o los motivos de la misma, como: Hechos ocurridos, local comercial, fecha, etc.</h5>
        <br/>
        <h2 class="mb-4 text-center">BUZON DE QUEJAS, SUGERENCIAS Y FELICITACIONES</h2>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form id="userForm" action="{{ route('user.store') }}" method="POST">
            @csrf
            <div class="form-group">
                <label for="Ciudad">Ciudad:</label>
                <select class="form-control" name="Ciudad" id="Ciudad">
                    @foreach($ClienteCiudad as $clienteCiudad)
                        <option value="{{ $clienteCiudad['idCiudad'] }}">{{ $clienteCiudad['Ciudad'] }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label for="Almacen">Almacen:</label>
                <select class="form-control" name="Almacen" id="Almacen">
                    <!-- @foreach($Bodega as $bodega)
                        <option value="{{ $bodega->Bodega }}">{{ $bodega->Nombre }}</option>
                    @endforeach -->
                </select>
            </div>

            <!-- Acordeón -->
            <div class="accordion" id="accordionExample">
                <div class="card">
                    <div class="card-header" id="headingOne">
                        <h2 class="mb-0">
                            <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                Servicio al cliente en ventas
                            </button>
                        </h2>
                    </div>
                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                        <div class="card-body">
                       
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for= "SCVPregunta1">Fecha de compra:</label>
                                    <input type="date" class="form-control {{ $errors->has('SCVPregunta1') ? 'is-invalid' : '' }}" id="SCVPregunta1" name="SCVPregunta1" value="{{ old('SCVPregunta1') }}">
                                    @if ($errors->has('SCVPregunta1'))
                                        <div class="invalid-feedback">
                                            {{ $errors->first('SCVPregunta1') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="SCVPregunta2">No. Fact:</label>
                                    <input type="text" class="form-control {{ $errors->has('SCVPregunta2') ? 'is-invalid' : '' }}" id="SCVPregunta2" name="SCVPregunta2" value="{{ old('SCVPregunta2') }}">
                                    @if ($errors->has('SCVPregunta2'))
                                        <div class="invalid-feedback">
                                            {{ $errors->first('SCVPregunta2') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="{{ $errors->has('SCVPregunta3') ? 'is-invalid' : '' }}">¿Al momento de la compra le entregaron la factura?</label>
                                        @if ($errors->has('SCVPregunta3'))
                                            <div class="invalid-feedback">
                                                {{ $errors->first('SCVPregunta3') }}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                            <div class="d-flex align-items-center">
                                                <div class="form-check mr-2">
                                                    <input class="form-check-input" type="radio" name="SCVPregunta3" id="SCVPregunta3Yes" value="1" {{ old('SCVPregunta3') == '1' ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="SCVPregunta3Yes">SI</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="SCVPregunta3" id="SCVPregunta3No" value="0" {{ old('SCVPregunta3') == '0' ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="SCVPregunta3No">NO</label>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                                
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="{{ $errors->has('SCVPregunta4') ? 'is-invalid' : '' }}">¿Le dieron a conocer las características del producto?</label>
                                        @if ($errors->has('SCVPregunta4'))
                                            <div class="invalid-feedback">
                                                {{ $errors->first('SCVPregunta4') }}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check mr-2">
                                                <input class="form-check-input" type="radio" name="SCVPregunta4" id="SCVPregunta4Yes" value="1" {{ old('SCVPregunta4') == '1' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta4Yes">SI</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="SCVPregunta4" id="SCVPregunta4No" value="0" {{ old('SCVPregunta4') == '0' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta4No">NO</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="{{ $errors->has('SCVPregunta5') ? 'is-invalid' : '' }}">¿Le probaron el producto?</label>
                                        @if ($errors->has('SCVPregunta5'))
                                            <div class="invalid-feedback">
                                                {{ $errors->first('SCVPregunta5') }}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check mr-2">
                                                <input class="form-check-input" type="radio" name="SCVPregunta5" id="SCVPregunta5Yes" value="1" {{ old('SCVPregunta5') == '1' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta5Yes">SI</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="SCVPregunta5" id="SCVPregunta5No" value="1" {{ old('SCVPregunta5') == '0' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta5No">NO</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="{{ $errors->has('SCVPregunta6') ? 'is-invalid' : '' }}">¿Le dieron a conocer las políticas de garantía?</label>
                                        @if ($errors->has('SCVPregunta6'))
                                            <div class="invalid-feedback">
                                                {{ $errors->first('SCVPregunta6') }}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check mr-2">
                                                <input class="form-check-input" type="radio" name="SCVPregunta6" id="SCVPregunta6Yes" value="1" {{ old('SCVPregunta6') == '1' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta6Yes">SI</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="SCVPregunta6" id="SCVPregunta6No" value="0" {{ old('SCVPregunta6') == '0' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta6No">NO</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label  class="{{ $errors->has('SCVPregunta7') ? 'is-invalid' : '' }}">¿En dónde le entregaron los productos?</label>
                                        @if ($errors->has('SCVPregunta7'))
                                            <div class="invalid-feedback">
                                                {{ $errors->first('SCVPregunta7') }}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check mr-2">
                                                <input class="form-check-input" type="radio" name="SCVPregunta7" id="SCVPregunta7Yes" value="EN EL LOCAL" {{ old('SCVPregunta7') == 'EN EL LOCAL' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta7Yes">EN EL LOCAL</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="SCVPregunta7" id="SCVPregunta7No" value="EN SU DOMICILIO" {{ old('SCVPregunta7') == 'EN SU DOMICILIO' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta7No">EN SU DOMICILIO</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="{{ $errors->has('SCVPregunta8') ? 'is-invalid' : '' }}" for="SCVPregunta8">¿El producto pudo satisfacer sus necesidades?</label>
                                        @if ($errors->has('SCVPregunta8'))
                                            <div class="invalid-feedback">
                                            {{ $errors->first('SCVPregunta8') }}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check mr-2">
                                                <input class="form-check-input" type="radio" name="SCVPregunta8" id="SCVPregunta8Yes" value="1" {{ old('SCVPregunta8') == '1' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta8Yes">SI</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="SCVPregunta8" id="SCVPregunta8No" value="0" {{ old('SCVPregunta8') == '0' ? 'checked' : '' }}>
                                                <label class="form-check-label" for="SCVPregunta8No">NO</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="MostrarSCVPregunta9">
                                <div class="form-group">
                                    <label for="SCVPregunta9">¿Porqué no? Por favor detalle</label>
                                    <input type="text" class="form-control {{ $errors->has('SCVPregunta9') ? 'is-invalid' : '' }}" id="SCVPregunta9" name="SCVPregunta9" value="{{ old('SCVPregunta9') }}">
                                    @if ($errors->has('SCVPregunta9'))
                                        <div class="invalid-feedback">
                                            {{ $errors->first('SCVPregunta9') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
             <!-- Radio buttons numerados del 1 al 5 en disposición horizontal -->
             <div class="form-group">
                <label>Cómo calificarías la atención recibida?, donde 1 es muy malo y  5 es excelente:</label>
                    <div class="row">
                        <div class="col-md-6">
                            <label class="{{ $errors->has('SCVPregunta10') ? 'is-invalid' : '' }}">Atención del vendedor:</label>
                            @if ($errors->has('SCVPregunta10'))
                                    <div class="invalid-feedback">
                                        {{ $errors->first('SCVPregunta10') }}
                                    </div>
                                @endif
                        </div>
                        <div class="col-md-6">
                            <div class="horizontal-radio-buttons">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="SCVPregunta10" id="SCVPregunta101" value="1" {{ old('SCVPregunta10') == '1' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="SCVPregunta101">1</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="SCVPregunta10" id="SCVPregunta102" value="2" {{ old('SCVPregunta10') == '2' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="SCVPregunta102">2</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="SCVPregunta10" id="SCVPregunta103" value="3" {{ old('SCVPregunta10') == '3' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="SCVPregunta103">3</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="SCVPregunta10" id="SCVPregunta104" value="4" {{ old('SCVPregunta10') == '4' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="SCVPregunta104">4</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="SCVPregunta10" id="SCVPregunta105" value="5" {{ old('SCVPregunta10') == '5' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="SCVPregunta105">5</label>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>

            <!-- Radio buttons numerados del 1 al 5 en disposición horizontal -->
            <div class="form-group">
            <label>Sugerencia o queja con respecto al proceso de venta:</label>
            <br/>
            <label class="{{ $errors->has('SCVPregunta11') ? 'is-invalid' : '' }}">Porque medio nos contactó:</label>
                <div class="horizontal-radio-buttons">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta111" value="VISITA AL LOCAL" {{ old('SCVPregunta11') == 'VISITA AL LOCAL' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta111">VISITA AL LOCAL</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta112" value="REFERIDO" {{ old('SCVPregunta11') == 'REFERIDO' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta112">REFERIDO</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta113" value="PUERTEO" {{ old('SCVPregunta11') == 'PUERTEO' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta113">PUERTEO</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta114" value="CHATTIGO" {{ old('SCVPregunta11') == 'CHATTIGO' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta114">CHATTIGO</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta115" value="FACEBOOK" {{ old('SCVPregunta11') == 'FACEBOOK' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta115">FACEBOOK</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta116" value="TIKTOK" {{ old('SCVPregunta11') == 'TIKTOK' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta116">TIKTOK</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="SCVPregunta11" id="SCVPregunta117" value="WEB" {{ old('SCVPregunta11') == 'WEB' ? 'checked' : '' }}>
                        <label class="form-check-label" for="SCVPregunta117">WEB</label>
                    </div>
                </div>
                @if ($errors->has('SCVPregunta11'))
                                    <div class="invalid-feedback">
                                        {{ $errors->first('SCVPregunta11') }}
                                    </div>
                                @endif
            </div>

             <!-- Radio buttons numerados del 1 al 5 en disposición horizontal -->
             <div class="form-group">
                        <label class="{{ $errors->has('SCVPregunta12') ? 'is-invalid' : '' }}">¿Cuál fue su forma de pago?</label>
                        <div class="horizontal-radio-buttons">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="SCVPregunta12" id="SCVPregunta121" value="CRÉDITO" {{ old('SCVPregunta12') == 'CRÉDITO' ? 'checked' : '' }}>
                                <label class="form-check-label" for="SCVPregunta121">CRÉDITO</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="SCVPregunta12" id="SCVPregunta122" value="EFECTIVO" {{ old('SCVPregunta12') == 'EFECTIVO' ? 'checked' : '' }}>
                                <label class="form-check-label" for="SCVPregunta122">EFECTIVO</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="SCVPregunta12" id="SCVPregunta123" value="TARJETA" {{ old('SCVPregunta12') == 'TARJETA' ? 'checked' : '' }}>
                                <label class="form-check-label" for="SCVPregunta123">TARJETA</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="SCVPregunta12" id="SCVPregunta124" value="NOTA DE CRÉDITO" {{ old('SCVPregunta12') == 'NOTA DE CRÉDITO' ? 'checked' : '' }}>
                                <label class="form-check-label" for="SCVPregunta124">NOTA DE CRÉDITO</label>
                            </div>
                        </div>
                        @if ($errors->has('SCVPregunta12'))
                                    <div class="invalid-feedback">
                                        {{ $errors->first('SCVPregunta12') }}
                                    </div>
                                @endif
                </div>
                            
            </div>

                        </div>
                    </div>
                <div class="card">
                    <div class="card-header" id="headingTwo">
                        <h2 class="mb-0">
                            <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Gestión del crédito
                            </button>
                        </h2>
                    </div>
                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                        <div class="card-body">
                        Contenido Gestión del crédito
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header" id="headingThree">
                        <h2 class="mb-0">
                            <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Gestión de cobranzas
                            </button>
                        </h2>
                    </div>
                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                        <div class="card-body">
                            Content Gestión de cobranzas
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header" id="headingFour">
                        <h2 class="mb-0">
                            <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Servicio Técnico
                            </button>
                        </h2>
                    </div>
                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                        <div class="card-body">
                            Content Servicio Técnico
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header" id="headingFive">
                        <h2 class="mb-0">
                            <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            Queja, sugerencia o  felicitaciones
                            </button>
                        </h2>
                    </div>
                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                        <div class="card-body">
                            Content Queja, sugerencia o  felicitaciones
                        </div>
                    </div>
                </div>

            <br/>
            <h5 class="mb-2">Déjanos tus datos para una gestión personalizada : </h5>
            <!-- Checkbox -->
            <div class="form-group form-check">
                <input type="checkbox" class="form-check-input" id="ProporcionarDatosCliente" name="ProporcionarDatosCliente" value="1" {{ old('ProporcionarDatosCliente') ? 'checked' : '' }}>
                <label class="form-check-label text-center" for="ProporcionarDatosCliente">Deseo proporcionar mis datos a Almacenes Point</label>
            </div>
            <div id="datos_cliente">
                <div class="form-group">
                    <label for="name">Nombres y Apellidos:</label>
                    <input type="text" class="form-control" id="NombreCompleto" name="NombreCompleto" value="{{ old('NombreCompleto') }}">
                </div>
                <div class="form-group">
                    <label for="name">Cédula:</label>
                    <input type="text" class="form-control" id="Cedula" name="Cedula" value="{{ old('Cedula') }}">
                </div>
                <div class="form-group">
                    <label for="name">Email:</label>
                    <input type="text" class="form-control" id="Email" name="Email" value="{{ old('Email') }}">
                </div>
                <div class="form-group">
                    <label for="name">Celular:</label>
                    <input type="text" class="form-control" id="Celular" name="Celular" value="{{ old('Celular') }}">
                </div>
            </div>

                    <!-- Checkbox -->
                    
        <div class="form-group form-check text-center">
                <input type="checkbox" class="form-check-input" id="AutorizacionTratamientoDatos" name="AutorizacionTratamientoDatos" value="1" {{ old('AutorizacionTratamientoDatos') ? 'checked' : '' }}>
                <label class="form-check-label" for="AutorizacionTratamientoDatos">Autorizo que Almacenes Point. realice el tratamiento de mis datos personales, conforme lo señalado en su Política de Privacidad, que conozco y acepto, los use para dar seguimiento al reclamo presentado y, de ser necesario, tome contacto conmigo por cualquier medio que he proporcionado.
 Declaro que, Almacenes Point podrá guardar como respaldo la versión digitalizada de este documento, la cual acepto como veraz y de igual valor que la física.
 <a href="https://point.com.ec/politicas-de-privacidad">https://point.com.ec/politicas-de-privacidad</a>
 
</label></div>
            <!-- Botón que abre el modal -->
            <div class="text-center mt-4">
                <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#confirmationModal">Enviar formulario</button>
            </div>
            <br/><br/>
        </form>


        <!-- Modal -->
        <div class="modal fade" id="confirmationModal" tabindex="-1" aria-labelledby="confirmationModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="confirmationModalLabel">Confirmar envío</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                    ¿Estás seguro de enviar el formulario?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="button" class="btn btn-primary" id="confirmSubmit">Aceptar</button>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script type="text/javascript">
        document.getElementById('confirmSubmit').addEventListener('click', function() {
            document.getElementById('userForm').submit();
        });

        document.getElementById('ProporcionarDatosCliente').addEventListener('change', function() {
        var datosCliente = document.getElementById('datos_cliente');
        if (this.checked) {
            datosCliente.style.display = 'block';
        } else {
            datosCliente.style.display = 'none';
            // Limpiar los campos
            document.getElementById('NombreCompleto').value = '';
            document.getElementById('Cedula').value = '';
            document.getElementById('Email').value = '';
            document.getElementById('Celular').value = '';
        }
        });
        
        // Mostrar los datos del cliente si el checkbox estaba marcado al cargar la página
        if (document.getElementById('ProporcionarDatosCliente').checked) {
            document.getElementById('datos_cliente').style.display = 'block';
        }
        
        try
        {
            //Opción SCVPregunta8No
            document.getElementById('SCVPregunta8No').addEventListener('change', function() {
            var datosCliente = document.getElementById('MostrarSCVPregunta9');
            console.log('SCVPregunta8No: ', this.checked)
            if (this.checked) {
                datosCliente.style.display = 'block';
            } else {
                datosCliente.style.display = 'none';
                // Limpiar los campos
                document.getElementById('SCVPregunta9').value = '';
            }
            });
            
            // Mostrar los datos del cliente si el checkbox estaba marcado al cargar la página
            if (document.getElementById('SCVPregunta8No').checked) {
                document.getElementById('MostrarSCVPregunta9').style.display = 'block';
            }

            //Opción SCVPregunta8Yes
            document.getElementById('SCVPregunta8Yes').addEventListener('change', function() {
            var datosCliente = document.getElementById('MostrarSCVPregunta9');
            console.log('SCVPregunta8Yes: ', this.checked)
            if (this.checked) {
                datosCliente.style.display = 'none';
                // Limpiar los campos
                document.getElementById('SCVPregunta9').value = '';
            } else {
                datosCliente.style.display = 'block';
            }
            });
            
            // Mostrar los datos del cliente si el checkbox estaba marcado al cargar la página
            if (document.getElementById('SCVPregunta8Yes').checked) {
                document.getElementById('MostrarSCVPregunta9').style.display = 'none';
            }
        }
        catch (error) {
                // Maneja cualquier error que ocurra en el bloque try
                console.log("Error SCVPregunta8.");
            } finally {
                // Este bloque se ejecuta siempre, haya o no una excepción
                console.log("La operación de división ha terminado.");
            }

        //Bodega filtro
        $(document).ready(function() {
            $('#Ciudad').on('change', function() {
                var categoriaId = $(this).val();
                if(categoriaId) {
                    $.ajax({
                        url: '/V1/Bodega/getBodegaList/' + categoriaId,
                        type: 'GET',
                        dataType: 'json',
                        success: function(data) {
                            $('#Almacen').empty();
                            $('#Almacen').append('<option value="">Selecciona un almacén</option>');
                            $.each(data, function(key, value) {
                                $('#Almacen').append('<option value="'+ value.Bodega +'">'+ value.Nombre +'</option>');
                            });
                        }
                    });
                } else {
                    $('#producto').empty();
                    $('#producto').append('<option value="">Selecciona un almacén</option>');
                }
            });
        });

    </script>
</body>
</html>