<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

use App\Http\Controllers\BodegaController;
use App\Http\Controllers\BuzonCabController;
use App\Http\Controllers\ClienteCiudadController;
use App\Http\Controllers\PdfController;
use App\Http\Controllers\UserController;
use App\Lib\CareTaker;

use App\Models\BuzonCab;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductosController;
use App\Http\Controllers\BaratazosController;
use App\Http\Controllers\Com_AsignacionDeVendedores;
$router->get('/', function () use ($router) {
    return redirect('/'.env('API_VERSION'));
});

$router->group(['prefix' => '/'.env('API_VERSION')], function () use ($router){

    $router->get('/', function () use ($router) {
        //return $router->app->version();
        return "<h2>Servicios WEB POINT activos</h2>";
    });
    // $router->get('/productos', ['uses' => 'Productos@getAll']);
    Route::get('/productos', [ProductosController::class, 'getAll']);
    Route::get('/baratazos', [BaratazosController::class, 'getAll']);
    Route::get('/buzon', [BuzonCabController::class, 'getAll']);
    Route::get('/buzon/BuzonCabCre', [BuzonCabController::class, 'BuzonCabCre'])->name('BuzonCabCre');
    Route::get('/buzon/BuzonGestionCredito', [BuzonCabController::class, 'BuzonGestionCredito']);
    Route::get('/buzon/BuzonServicioClienteVenta', [BuzonCabController::class, 'BuzonServicioClienteVenta']);
    Route::get('/buzon/BuzonGestionCobranza', [BuzonCabController::class, 'BuzonGestionCobranza']);
    Route::get('/buzon/BuzonServicioTecnico', [BuzonCabController::class, 'BuzonServicioTecnico']);
    Route::get('/buzon/BuzonQuejasSF', [BuzonCabController::class, 'BuzonQuejasSF']);
    Route::get('/buzon/BuzonCliente', [BuzonCabController::class, 'BuzonCliente']);

    Route::get('/user/create', [UserController::class, 'create'])->name('user.create');
    Route::post('/user/store', [UserController::class, 'store'])->name('user.store');
    //Mail
    Route::get('/buzon/enviar-correo', [BuzonCabController::class, 'enviarCorreo']);
    Route::get('/buzon/BuzonEnvioCorreo/{idBuzonCab}', [PdfController::class, 'BuzonEnvioCorreo']);
    //Test SSL
    Route::get('/test-ssl', 'App\Http\Controllers\TestSSLController@testSSL');
    //Pruebas Pdf
    Route::get('/generate-pdf-as-base64/{idBuzonCab}', [PdfController::class, 'generatePdfAsBase64']);
    Route::get('/send-pdf-by-email', [PdfController::class, 'sendPdfByEmail']);
    //Update bodega
    Route::get('/Bodega', [BodegaController::class, 'getAll']);
    //Servicio filtrar bodegas por la ciudad que escoja
    Route::get('/Bodega/getBodegaList/{idCiudad}', [BodegaController::class, 'getBodegaList']);
    //Ciudad
    Route::get('/ClienteCiudad', [ClienteCiudadController::class, 'getAll']);
    //Traer lista de ciudades
    Route::get('/ClienteCiudad/getClienteCiudadList', [ClienteCiudadController::class, 'getClienteCiudadList']);
    



});


